(function() {
  // Patch window.fetch
  const origFetch = window.fetch;
  window.fetch = async function(...args) {
    const response = await origFetch.apply(this, args);
    try {
      if (
        typeof args[0] === "string" &&
        args[0].includes("/api/request/getkeywordcalendar")
      ) {
        response.clone().json().then(data => {
          window.localStorage.setItem("EXPRESS_TICKET_RESPONSE", JSON.stringify(data));
        }).catch(()=>{});
      }
    } catch(e) {}
    return response;
  };

  // Patch XMLHttpRequest
  const origOpen = XMLHttpRequest.prototype.open;
  XMLHttpRequest.prototype.open = function(method, url, ...rest) {
    this._isTarget =
      method === "POST" && url.includes("/api/request/getkeywordcalendar");
    return origOpen.apply(this, [method, url, ...rest]);
  };
  const origSend = XMLHttpRequest.prototype.send;
  XMLHttpRequest.prototype.send = function(...args) {
    if (this._isTarget) {
      this.addEventListener("load", function() {
        try {
          const data = JSON.parse(this.responseText);
          window.localStorage.setItem("EXPRESS_TICKET_RESPONSE", JSON.stringify(data));
        } catch (e) {}
      });
    }
    return origSend.apply(this, args);
  };
})();
