// *** URL für die Lizenzschlüssel-Datei ***
const LICENSE_URL = "https://kevin-dennis.de/licenses.txt"; 

const EXPRESS_URL = "https://me-hpgermany.tickets.heide-park.de/fastlanewizardstatic/ExpressTicketDE";
const TAGES_URL = "https://me-hpgermany.tickets.heide-park.de/snap-calendar-wizard/SnapWizardDE/SnapWizardAdmissionDE";
const HALLOWEEN_URL = "https://me-hpgermany.tickets.heide-park.de/fastlanewizardstatic/Halloween%20-%20DE";
const FOTO_PASS_URL = "https://me-hpgermany.tickets.heide-park.de/packageDetails/62588/navItem/Foto-Pass";
const PARKPLATZ_URL = "https://me-hpgermany.tickets.heide-park.de/packageDetails/76521/navItem/Parkplatz-Ticket";
const PARTY_PAKET_URL = "https://me-hpgermany.tickets.heide-park.de/packageDetails/102830/navItem/Party-Pakete";
const MAZE_URL = "https://me-hpgermany.tickets.heide-park.de/packageDetails/89411";

const API_URLS = {
  express: "https://me-hpgermany.tickets.heide-park.de/api/request/getkeywordcalendar",
  tages:   "https://me-hpgermany.tickets.heide-park.de/api/request/getkeywordcalendar",
  halloween: "https://me-hpgermany.tickets.heide-park.de/api/request/getkeywordcalendar",
  promo: "https://me-hpgermany.tickets.heide-park.de/api/request/getgiftcoderemainingcount",
  fotoPass: "https://me-hpgermany.tickets.heide-park.de/api/request/getmerchantpackageeventdates",
  parkplatz: "https://me-hpgermany.tickets.heide-park.de/api/request/getmerchantpackageeventdates",
  partyPaket: "https://me-hpgermany.tickets.heide-park.de/api/request/getmerchantpackageeventdates",
  maze: "https://me-hpgermany.tickets.heide-park.de/api/request/getmerchantpackageeventdates"
};

const API_PAYLOADS = {
  express: { "display_zero_capacity": "0", "keyword": "ExpressTicketDE", "end_date": "2025-11-02", "start_date": "2025-10-13", "request_type": "GetKeywordCalendar", "_version": "6.17.9", "application_id": "1500", "merchant_id": "6500", "machine_id": "500", "agent_id": "5", "user_id": "5", "device": "desktop", "language": "de-de", "request_token": "5B98CF43851DAD16D9C16799EE4998EB", "cart_id": "536057884", "cart_key": "1022794776", "session_id": "runi.070744.778" },
  tages: { "display_zero_capacity": "0", "keyword": "SnapWizardAdmissionDE", "end_date": "2025-12-07", "start_date": "2025-10-13", "request_type": "GetKeywordCalendar", "_version": "6.17.9", "application_id": "1500", "merchant_id": "6500", "machine_id": "500", "agent_id": "5", "user_id": "5", "device": "desktop", "language": "de-de", "request_token": "F85973C97DB161D8BFB98660E7720A91", "cart_id": "536227027", "cart_key": "3524604794", "session_id": "fxyv.182504.140" },
  halloween: { "display_zero_capacity": "0", "keyword": "Halloween - DE", "end_date": "2025-11-02", "start_date": "2025-10-13", "request_type": "GetKeywordCalendar", "_version": "6.17.9", "application_id": "1500", "merchant_id": "6500", "machine_id": "500", "agent_id": "5", "user_id": "5", "device": "desktop", "language": "de-de", "request_token": "9F5D4696FF864B61106905D27B1F88A9", "cart_id": "536227027", "cart_key": "3524604794", "session_id": "fxyv.182504.140" },
  promo: {"gift_offer_id":"18325","gift_code":"","request_type":"GetGiftCodeRemainingCount","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"33465727AB9229373D05D4138367D4DC","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  fotoPass: {"P":[{"CT":[{"id":"1091","qty":1}],"event_id":"996","id":"62588"}],"extra_movie":"date","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-15","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"EC1958C94CB2334DC6C60572468A6718","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  parkplatz: {"P":[{"CT":[{"id":"12812","qty":1}],"event_id":"2163","id":"76521"}],"extra_movie":"date","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-15","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"087CEE857EBC3F0EFCADFB195C374A0F","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  peppaParty: {"P":[{"CT":[{"id":"4584","qty":1}],"event_id":"2234","id":"102830"}],"extra_movie":"date","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-15","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"7D5721A3B20DD5DF8DEC7FE82C9CDE93","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  drachenParty: {"P":[{"CT":[{"id":"4584","qty":1}],"event_id":"2234","id":"102834"}],"extra_movie":"date","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-15","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"7E238484EB6277EA49342C2749F174B0","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  ghostbustersParty: {"P":[{"CT":[{"id":"4584","qty":1}],"event_id":"2234","id":"102832"}],"extra_movie":"date","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-15","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"4E8CFAD450B67667173F327A9B303261","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  heideparkParty: {"P":[{"CT":[{"id":"4584","qty":1}],"event_id":"2234","id":"102836"}],"extra_movie":"date","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-15","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"37B9F270F55ACFEB2E6A8E0897310AEC","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  subterraMaze: {"P":[{"CT":[{"id":"4191","qty":1}],"event_id":"1926","id":"89411"}],"extra_movie":"date_time","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-14","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"FD4F1478CF12F6D7D7FD2FB21EAA6BCC","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  mortonMaze: {"P":[{"CT":[{"id":"4191","qty":1}],"event_id":"1291","id":"89412"}],"extra_movie":"date_time","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-14","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"2FC6E493639913A7ED14C3C30BB7B2AE","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"},
  parasomnisMaze: {"P":[{"CT":[{"id":"4191","qty":1}],"event_id":"3059","id":"104235"}],"extra_movie":"date_time","identify_customer_types":1,"min_capacity":1,"version":"2","start_date":"2025-10-14","end_date":"2025-11-02","display_zero_capacity":"0","include_times":true,"request_type":"GetMerchantPackageEventDates","_version":"6.17.9","application_id":"1500","merchant_id":"6500","machine_id":"500","agent_id":"5","user_id":"5","device":"desktop","language":"de-de","request_token":"5DA49B229D5A6CFE5780D7C654A1C7B7","cart_id":"536506217","cart_key":"4205873474","session_id":"ftsq.193253.484"}
};

const EXPRESS_TICKET_VERSIONS = [ "Express Ticket Platin 🏆", "Express Ticket Gold 🥇", "Express Ticket Silber 🥈", "Express Ticket Bronze 🥉" ];
const TAGES_TICKET_VERSIONS = [ "Tages- & Abend-Ticket", "Foto-Pass 📸", "Parkplatz 🅿️" ];
const PARTY_PAKETE_VERSIONS = [ "Peppas Party-Paket 🐷", "Drachenzähmen Party-Paket 🐉", "Ghostbusters Party-Paket 👻", "Heide Park Party-Paket 🎉" ];
const MAZE_TICKET_VERSIONS = [ "SubTerra", "Grand Hotel Morton", "Parasomnis" ];
let currentExpressIndex = 0;
let currentTagesIndex = 0;
let currentPartyIndex = 0;
let currentMazeIndex = 0;
let mode;

document.addEventListener("DOMContentLoaded", () => {
    const licenseContainer = document.getElementById("license-container");
    const mainContent = document.getElementById("main-content");
    const licenseInput = document.getElementById("license-input");
    const licenseSubmit = document.getElementById("license-submit");
    const licenseError = document.getElementById("license-error");
    const licenseRefreshBtn = document.getElementById("license-refresh-btn");
    const licenseUserDisplay = document.getElementById("license-user-display");
    const licenseExpiryDisplay = document.getElementById("license-expiry-display");
    const licenseKeyDisplay = document.getElementById("license-key-display");
    const logoutBtn = document.getElementById("logout-btn");
    const div = document.getElementById("ticket-table");
    const versionTitle = document.getElementById("versionTitle");
    const leftBtn = document.getElementById("left");
    const rightBtn = document.getElementById("right");
    const selectorRow = document.getElementById("selector-row");
    const mainTitle = document.getElementById("main-title");
    const loader = document.getElementById("loader");
    const summaryBar = document.getElementById("summary-bar");
    const tooltipSwitch = document.getElementById("tooltip-switch");
    const cacheDurationInput = document.getElementById("cache-duration-input");
    const badgeIntervalInput = document.getElementById("badge-interval-input");
    const favoriteViewSelect = document.getElementById("favorite-view-select");
    const themeSelect = document.getElementById("theme-select");
    const promoCodeInput = document.getElementById("promo-code-input");
    const checkPromoBtn = document.getElementById("check-promo-btn");
    const promoResult = document.getElementById("promo-result");
    const ticketViewContainer = document.getElementById("ticket-view-container");
    const promoCheckerContainer = document.getElementById("promo-checker-container");
    const settingsContainer = document.getElementById("settings-container");
    const loadExpressBtn = document.getElementById("load-express");
    const loadTagesBtn = document.getElementById("load-tages");
    const loadPartyBtn = document.getElementById("load-party");
    const loadMazeBtn = document.getElementById("load-maze");
    const loadPromoBtn = document.getElementById("load-promo");
    const loadSettingsBtn = document.getElementById("load-settings");
    const forceReloadBtn = document.getElementById("force-reload-btn");
    const lastUpdatedDisplay = document.getElementById("last-updated-display");
    const topbarButtons = [loadExpressBtn, loadTagesBtn, loadPartyBtn, loadMazeBtn, loadPromoBtn, loadSettingsBtn];
    const clearCacheBtn = document.getElementById("clear-cache-btn");

    clearCacheBtn.addEventListener('click', () => {
        if (confirm("Möchtest du wirklich alle gespeicherten Ticketdaten löschen? Dies kann nicht rückgängig gemacht werden.")) {
            showLoader();
            chrome.storage.local.remove(['cachedData', 'cacheTimestamp'], () => {
                alert("Gespeicherte Daten wurden gelöscht.");
                loadAllData(true);
            });
        }
    });

    function forceLogout(message) {
        if (message) alert(message);
        chrome.storage.local.remove(['isLicensed', 'licenseKey', 'licenseUser', 'licenseExpiry'], () => {
            window.location.reload();
        });
    }

    function displayLicenseInfo(data) {
        if (data.licenseUser) licenseUserDisplay.textContent = data.licenseUser;
        if (data.licenseKey) licenseKeyDisplay.textContent = data.licenseKey;
        if (data.licenseExpiry) {
            const [day, month, year] = data.licenseExpiry.split('.');
            const expiryDate = new Date(`${year}-${month}-${day}`);
            const today = new Date();
            today.setHours(0, 0, 0, 0);

            if (expiryDate < today) {
                forceLogout("Deine Lizenz ist abgelaufen.");
                return false;
            } else {
                const diffDays = Math.ceil((expiryDate - today) / (1000 * 60 * 60 * 24));
                licenseExpiryDisplay.textContent = `${data.licenseExpiry} (noch ${diffDays} Tage)`;
                licenseExpiryDisplay.style.color = diffDays < 7 ? 'orange' : 'green';
                return true;
            }
        }
        return false;
    }

    function initializeApp(data) {
        licenseContainer.style.display = 'none';
        mainContent.style.display = 'block';

        if (!displayLicenseInfo(data)) return;

        if (data.theme && data.theme !== 'theme-default') {
            document.body.classList.add(data.theme);
        }
        themeSelect.value = data.theme || 'theme-default';
        tooltipSwitch.checked = data.tooltipEnabled !== false;
        cacheDurationInput.value = data.cacheDuration || 1;
        badgeIntervalInput.value = data.badgeInterval || 10;
        mode = data.favoriteView || "express";
        favoriteViewSelect.value = mode;

        switchView(mode);
        if (!['promo', 'settings'].includes(mode)) {
            loadAllData();
        }
        
        updateLastUpdatedTimer();
        setInterval(updateLastUpdatedTimer, 5000);
    }

    async function validateLicenseKey(key, isRefresh = false) {
        if (!key) {
            licenseError.textContent = "Bitte gib einen Schlüssel ein.";
            return;
        }
        licenseError.textContent = "Überprüfe Schlüssel...";

        try {
            const response = await fetch(LICENSE_URL, { cache: "no-store" });
            if (!response.ok) throw new Error('Lizenz-Server nicht erreichbar.');
            
            const text = await response.text();
            const keyDataLine = text.split(/\r?\n/).find(line => line.split('|')[0].trim() === key);
            if (!keyDataLine) throw new Error('Lizenzschlüssel ungültig oder entfernt.');

            const [licenseKey, licenseExpiry, licenseUser] = keyDataLine.split('|').map(s => s.trim());
            const [day, month, year] = licenseExpiry.split('.');
            const expiryDate = new Date(`${year}-${month}-${day}`);
            const today = new Date(); today.setHours(0, 0, 0, 0);
            if (expiryDate < today) throw new Error('Lizenzschlüssel ist abgelaufen.');
            
            const licenseData = { isLicensed: true, licenseKey, licenseExpiry, licenseUser };
            chrome.storage.local.set(licenseData, () => {
                licenseError.textContent = "";
                if (isRefresh) {
                    displayLicenseInfo(licenseData);
                    alert("Lizenz erfolgreich aktualisiert!");
                } else {
                    initializeApp(licenseData);
                }
            });

        } catch (error) {
            if (isRefresh) {
                forceLogout(`Deine Lizenz ist nicht mehr gültig: ${error.message}`);
            } else {
                licenseError.textContent = `Fehler: ${error.message}`;
            }
        }
    }

    licenseSubmit.addEventListener('click', () => validateLicenseKey(licenseInput.value.trim()));
    licenseInput.addEventListener('keyup', (e) => { if (e.key === 'Enter') validateLicenseKey(licenseInput.value.trim()); });
    logoutBtn.addEventListener('click', () => {
         if (confirm("Möchtest du die Lizenz wirklich von diesem Gerät entfernen?")) {
            forceLogout();
         }
    });
    licenseRefreshBtn.addEventListener('click', (e) => {
        e.preventDefault();
        chrome.storage.local.get('licenseKey', data => {
            if (data.licenseKey) {
                 validateLicenseKey(data.licenseKey, true);
            }
        });
    });

    chrome.storage.local.get([
        'isLicensed', 'licenseKey', 'licenseUser', 'licenseExpiry', 
        'theme', 'tooltipEnabled', 'cacheDuration', 'badgeInterval', 'favoriteView'
    ], (data) => {
        if (data.isLicensed) {
            initializeApp(data);
        } else {
            licenseContainer.style.display = 'block';
            mainContent.style.display = 'none';
        }
    });

    const getLocalDate = () => {
        const now = new Date();
        const year = now.getFullYear();
        const month = (now.getMonth() + 1).toString().padStart(2, '0');
        const day = now.getDate().toString().padStart(2, '0');
        return `${year}-${month}-${day}`;
    };

    themeSelect.addEventListener('change', () => {
        document.body.className = '';
        const selectedTheme = themeSelect.value;
        if (selectedTheme !== 'theme-default') {
            document.body.classList.add(selectedTheme);
        }
        chrome.storage.local.set({ theme: selectedTheme });
    });

    tooltipSwitch.addEventListener('change', () => {
        chrome.storage.local.set({ tooltipEnabled: tooltipSwitch.checked });
    });

    cacheDurationInput.addEventListener('change', () => {
        const duration = parseInt(cacheDurationInput.value, 10);
        if (duration && duration >= 1) chrome.storage.local.set({ cacheDuration: duration });
    });
    
    badgeIntervalInput.addEventListener('change', () => {
        const interval = parseInt(badgeIntervalInput.value, 10);
        if (interval && interval >= 1) chrome.storage.local.set({ badgeInterval: interval });
    });

    favoriteViewSelect.addEventListener('change', () => {
        chrome.storage.local.set({ favoriteView: favoriteViewSelect.value });
    });
    
    forceReloadBtn.addEventListener('click', () => loadAllData(true));

    const showLoader = () => { loader.style.display = 'block'; };
    const hideLoader = () => { loader.style.display = 'none'; };

    function updateTitle() {
        if (mode === 'express') {
            versionTitle.textContent = EXPRESS_TICKET_VERSIONS[currentExpressIndex];
        } else if (mode === 'tages') {
            versionTitle.textContent = TAGES_TICKET_VERSIONS[currentTagesIndex];
        } else if (mode === 'party') {
            versionTitle.textContent = PARTY_PAKETE_VERSIONS[currentPartyIndex];
        } else if (mode === 'maze') {
            versionTitle.textContent = MAZE_TICKET_VERSIONS[currentMazeIndex];
        }
    }

    function getSoldClass(sold, capacity) {
        const percentage = capacity > 0 ? (sold / capacity) * 100 : 0;
        if (percentage >= 90) return 'red';
        if (percentage >= 50) return 'orange';
        return 'green';
    }

    function* dateRangeISO(start, end) {
        let d = new Date(start);
        const endDate = new Date(end);
        while (d <= endDate) {
            yield d.toISOString().slice(0, 10);
            d.setUTCDate(d.getUTCDate() + 1);
        }
    }
    
    function switchView(newMode) {
        mode = newMode;
        ticketViewContainer.style.display = 'none';
        promoCheckerContainer.style.display = 'none';
        settingsContainer.style.display = 'none';
        
        topbarButtons.forEach(btn => btn.classList.remove('active'));

        if (['express', 'tages', 'party', 'maze'].includes(mode)) {
            ticketViewContainer.style.display = 'block';
            selectorRow.style.display = 'flex';
            mainTitle.textContent = "Ticket Übersicht";
            updateTitle();
            if (mode === 'express') {
                loadExpressBtn.classList.add('active');
                chrome.storage.local.get('cachedData', (result) => renderExpressTable(result.cachedData?.express));
            } else if (mode === 'tages') {
                loadTagesBtn.classList.add('active');
                chrome.storage.local.get('cachedData', (result) => renderTagesView(result.cachedData));
            } else if (mode === 'party') {
                loadPartyBtn.classList.add('active');
                chrome.storage.local.get('cachedData', (result) => renderPartyView(result.cachedData));
            } else if (mode === 'maze') {
                loadMazeBtn.classList.add('active');
                chrome.storage.local.get('cachedData', (result) => renderMazeView(result.cachedData));
            }
        } else if (mode === 'promo') {
            promoCheckerContainer.style.display = 'block';
            loadPromoBtn.classList.add('active');
        } else if (mode === 'settings') {
            settingsContainer.style.display = 'block';
            loadSettingsBtn.classList.add('active');
        }
    }

    loadTagesBtn.addEventListener('click', () => switchView("tages"));
    loadExpressBtn.addEventListener('click', () => switchView("express"));
    loadPartyBtn.addEventListener('click', () => switchView("party"));
    loadMazeBtn.addEventListener('click', () => switchView("maze"));
    loadPromoBtn.addEventListener('click', () => switchView("promo"));
    loadSettingsBtn.addEventListener('click', () => switchView("settings"));

    leftBtn.addEventListener('click', () => {
        if (mode === 'express') {
            currentExpressIndex = (currentExpressIndex - 1 + EXPRESS_TICKET_VERSIONS.length) % EXPRESS_TICKET_VERSIONS.length;
            chrome.storage.local.get('cachedData', (result) => renderExpressTable(result.cachedData?.express));
        } else if (mode === 'tages') {
            currentTagesIndex = (currentTagesIndex - 1 + TAGES_TICKET_VERSIONS.length) % TAGES_TICKET_VERSIONS.length;
            chrome.storage.local.get('cachedData', (result) => renderTagesView(result.cachedData));
        } else if (mode === 'party') {
            currentPartyIndex = (currentPartyIndex - 1 + PARTY_PAKETE_VERSIONS.length) % PARTY_PAKETE_VERSIONS.length;
            chrome.storage.local.get('cachedData', (result) => renderPartyView(result.cachedData));
        } else if (mode === 'maze') {
            currentMazeIndex = (currentMazeIndex - 1 + MAZE_TICKET_VERSIONS.length) % MAZE_TICKET_VERSIONS.length;
            chrome.storage.local.get('cachedData', (result) => renderMazeView(result.cachedData));
        }
        updateTitle();
    });

    rightBtn.addEventListener('click', () => {
        if (mode === 'express') {
            currentExpressIndex = (currentExpressIndex + 1) % EXPRESS_TICKET_VERSIONS.length;
            chrome.storage.local.get('cachedData', (result) => renderExpressTable(result.cachedData?.express));
        } else if (mode === 'tages') {
            currentTagesIndex = (currentTagesIndex + 1) % TAGES_TICKET_VERSIONS.length;
            chrome.storage.local.get('cachedData', (result) => renderTagesView(result.cachedData));
        } else if (mode === 'party') {
            currentPartyIndex = (currentPartyIndex + 1) % PARTY_PAKETE_VERSIONS.length;
            chrome.storage.local.get('cachedData', (result) => renderPartyView(result.cachedData));
        } else if (mode === 'maze') {
            currentMazeIndex = (currentMazeIndex + 1) % MAZE_TICKET_VERSIONS.length;
            chrome.storage.local.get('cachedData', (result) => renderMazeView(result.cachedData));
        }
        updateTitle();
    });
    
    async function checkPromoCode() {
        const giftCode = promoCodeInput.value.trim();
        if (!giftCode) {
            promoResult.textContent = "Bitte einen Code eingeben.";
            promoResult.style.color = "#c91926";
            return;
        }

        promoResult.textContent = "Prüfe Code...";
        promoResult.style.color = document.body.classList.contains('theme-dark-mode') ? '#f6f7fb' : '#2b364b';
        showLoader();

        const payload = { ...API_PAYLOADS.promo, gift_code: giftCode };
        const contextUrl = "https://me-hpgermany.tickets.heide-park.de/merchandise";

        try {
            const result = await executeFetch(contextUrl, API_URLS.promo, payload);
            const serviceResponse = result.data.SERVICE;

            if (serviceResponse && typeof serviceResponse.remaining_count !== 'undefined') {
                const remainingCount = serviceResponse.remaining_count;
                if (remainingCount === "-1") {
                    promoResult.textContent = "Ungültiger Code.";
                    promoResult.style.color = "#c91926";
                } else {
                    promoResult.textContent = `Noch verfügbar: ${remainingCount}`;
                    promoResult.style.color = "green";
                }
            } else {
                promoResult.textContent = "Ungültiger Code oder Fehler.";
                promoResult.style.color = "#c91926";
                console.error("Antwort enthielt kein 'remaining_count' im SERVICE-Objekt:", result.data);
            }
        } catch (error) {
            promoResult.textContent = `Fehler: ${error.message}`;
            promoResult.style.color = "#c91926";
            console.error("Fehler bei der Promo-Code-Prüfung:", error);
        } finally {
            hideLoader();
        }
    }

    checkPromoBtn.addEventListener('click', checkPromoCode);
    promoCodeInput.addEventListener('keyup', (e) => { if (e.key === 'Enter') checkPromoCode(); });


    function executeFetch(tabUrl, apiUrl, apiPayload) {
        return new Promise((resolve, reject) => {
            const scriptToExecute = (tabId) => {
                chrome.scripting.executeScript({
                    target: { tabId },
                    func: (apiUrl, apiPayload) => fetch(apiUrl, { method: "POST", headers: { "accept": "application/json, text/plain, */*", "content-type": "application/json;charset=UTF-8", "com-accessopassport-app-id": "1500", "com-accessopassport-client": "accesso26", "com-accessopassport-language": "de-de", "com-accessopassport-merchant-id": "6500" }, body: JSON.stringify(apiPayload), credentials: "include" }).then(r => r.json()).catch(e => ({error: `Antwort ist kein gültiges JSON: ${e.message}`})),
                    args: [apiUrl, apiPayload]
                }, (results) => {
                    chrome.tabs.remove(tabId, () => { if (chrome.runtime.lastError) {} });
                    if (chrome.runtime.lastError) return reject(new Error(chrome.runtime.lastError.message));
                    const data = results?.[0]?.result;
                    if (data && !data.error) resolve({ data });
                    else reject(new Error(data?.error || "Skript-Ausführung fehlgeschlagen."));
                });
            };
            const waitForTab = (tabId) => {
                const listener = (updatedTabId, changeInfo) => { 
                    if (updatedTabId === tabId && changeInfo.status === 'complete') { 
                        chrome.tabs.onUpdated.removeListener(listener); 
                        setTimeout(() => scriptToExecute(tabId), 250); 
                    } 
                };
                chrome.tabs.onUpdated.addListener(listener);
            };
            chrome.tabs.create({ url: tabUrl, active: false }, (newTab) => { 
                if (newTab && newTab.id) waitForTab(newTab.id);
                else reject(new Error(`Konnte Tab für ${tabUrl} nicht erstellen.`)); 
            });
        });
    }

    function loadAllData(forceRefresh = false) {
        chrome.storage.local.get(['cachedData', 'cacheTimestamp', 'cacheDuration'], (result) => {
            const now = new Date().getTime();
            const cacheDuration = (result.cacheDuration || 1) * 60 * 1000;
            const oldData = result.cachedData; 

            if (!forceRefresh && oldData && result.cacheTimestamp && (now - result.cacheTimestamp < cacheDuration)) {
                renderSummary(oldData);
                if (mode === 'tages') renderTagesView(oldData);
                else if (mode === 'express') renderExpressTable(oldData.express);
                else if (mode === 'party') renderPartyView(oldData);
                else if (mode === 'maze') renderMazeView(oldData);
                return;
            }

            showLoader();
            summaryBar.innerHTML = `Lade Zusammenfassung...`;
            
            Promise.all([
                executeFetch(EXPRESS_URL, API_URLS.express, API_PAYLOADS.express),
                executeFetch(TAGES_URL, API_URLS.tages, API_PAYLOADS.tages),
                executeFetch(HALLOWEEN_URL, API_URLS.halloween, API_PAYLOADS.halloween),
                executeFetch(FOTO_PASS_URL, API_URLS.fotoPass, API_PAYLOADS.fotoPass),
                executeFetch(PARKPLATZ_URL, API_URLS.parkplatz, API_PAYLOADS.parkplatz),
                executeFetch(PARTY_PAKET_URL, API_URLS.partyPaket, API_PAYLOADS.peppaParty),
                executeFetch(PARTY_PAKET_URL, API_URLS.partyPaket, API_PAYLOADS.drachenParty),
                executeFetch(PARTY_PAKET_URL, API_URLS.partyPaket, API_PAYLOADS.ghostbustersParty),
                executeFetch(PARTY_PAKET_URL, API_URLS.partyPaket, API_PAYLOADS.heideparkParty),
                executeFetch(MAZE_URL, API_URLS.maze, API_PAYLOADS.subterraMaze),
                executeFetch(MAZE_URL, API_URLS.maze, API_PAYLOADS.mortonMaze),
                executeFetch(MAZE_URL, API_URLS.maze, API_PAYLOADS.parasomnisMaze)
            ]).then(([expressResult, tagesResult, halloweenResult, fotoPassResult, parkplatzResult, peppaResult, drachenResult, ghostbustersResult, heideparkResult, subterraResult, mortonResult, parasomnisResult]) => {
                
                const newData = { 
                    express: expressResult.data, 
                    tages: tagesResult.data, 
                    halloween: halloweenResult.data,
                    fotoPass: fotoPassResult.data,
                    parkplatz: parkplatzResult.data,
                    peppaParty: peppaResult.data,
                    drachenParty: drachenResult.data,
                    ghostbustersParty: ghostbustersResult.data,
                    heideparkParty: heideparkResult.data,
                    subterraMaze: subterraResult.data,
                    mortonMaze: mortonResult.data,
                    parasomnisMaze: parasomnisResult.data
                };
                
                const mergedData = mergeWithOldData(oldData, newData);

                chrome.storage.local.set({ cachedData: mergedData, cacheTimestamp: new Date().getTime() }, () => {
                    updateLastUpdatedTimer();
                });
                
                renderSummary(mergedData);
                if (mode === 'tages') renderTagesView(mergedData);
                else if (mode === 'express') renderExpressTable(mergedData.express);
                else if (mode === 'party') renderPartyView(mergedData);
                else if (mode === 'maze') renderMazeView(mergedData);
                
            }).catch(error => {
                div.innerHTML = `<span class="none-row">Fehler: ${error.message}</span>`;
                summaryBar.innerHTML = "Fehler beim Laden.";
            }).finally(() => {
                hideLoader();
            });
        });
    }
    
    function mergeWithOldData(oldData, newData) {
        if (!oldData) return newData;
    
        const mergeKeywordCalendarData = (oldDays, newDays) => {
            if (!Array.isArray(oldDays)) oldDays = oldDays ? [oldDays] : [];
            if (!Array.isArray(newDays)) newDays = newDays ? [newDays] : [];
            
            const newMap = new Map(newDays.map(item => [item.date, item]));
            
            for (const oldDay of oldDays) {
                if (!newMap.has(oldDay.date)) {
                    if (oldDay.PS && oldDay.PS.P) {
                        const tickets = Array.isArray(oldDay.PS.P) ? oldDay.PS.P : [oldDay.PS.P];
                        tickets.forEach(p => { 
                            p.available = "0"; 
                            p.soldOut = true; 
                        });
                    }
                    newDays.push(oldDay);
                } else {
                    const newDay = newMap.get(oldDay.date);
                    if (oldDay.PS && oldDay.PS.P && newDay.PS && newDay.PS.P) {
                        const oldTickets = Array.isArray(oldDay.PS.P) ? oldDay.PS.P : [oldDay.PS.P];
                        const newTickets = Array.isArray(newDay.PS.P) ? newDay.PS.P : [newDay.PS.P];
                        const newTicketMap = new Map(newTickets.map(p => [p.name, p]));
                        
                        for (const oldTicket of oldTickets) {
                            if (!newTicketMap.has(oldTicket.name)) {
                                oldTicket.available = "0";
                                oldTicket.soldOut = true;
                                newTickets.push(oldTicket);
                            }
                        }
                        newDay.PS.P = newTickets;
                    }
                }
            }
            return newDays;
        };
    
        const mergePackageData = (oldDays, newDays) => {
            if (!Array.isArray(oldDays)) oldDays = oldDays ? [oldDays] : [];
            if (!Array.isArray(newDays)) newDays = newDays ? [newDays] : [];
            const newMap = new Map(newDays.map(item => [item.date, item]));
    
            for (const oldDay of oldDays) {
                if (!newMap.has(oldDay.date)) {
                    if (oldDay.T) {
                        oldDay.T.available = "0";
                        oldDay.T.used = oldDay.T.capacity;
                    }
                    newDays.push(oldDay);
                } else {
                     const newDay = newMap.get(oldDay.date);
                     if (oldDay.T && !newDay.T) {
                         oldDay.T.available = "0";
                         oldDay.T.used = oldDay.T.capacity;
                         newDay.T = oldDay.T;
                     }
                }
            }
            return newDays;
        };
    
        const mergeMazeData = (oldDays, newDays) => {
            if (!Array.isArray(oldDays)) oldDays = oldDays ? [oldDays] : [];
            if (!Array.isArray(newDays)) newDays = newDays ? [newDays] : [];
            const newMap = new Map(newDays.map(item => [item.date, item]));
    
            for (const oldDay of oldDays) {
                if (!newMap.has(oldDay.date)) {
                    if (oldDay.T) {
                        const slots = Array.isArray(oldDay.T) ? oldDay.T : [oldDay.T];
                        slots.forEach(slot => {
                            slot.available = "0";
                            slot.used = slot.capacity;
                        });
                    }
                    newDays.push(oldDay);
                } else {
                    const newDay = newMap.get(oldDay.date);
                    if (oldDay.T && newDay.T) {
                        const oldSlots = Array.isArray(oldDay.T) ? oldDay.T : [oldDay.T];
                        const newSlots = Array.isArray(newDay.T) ? newDay.T : [newDay.T];
                        const newSlotMap = new Map(newSlots.map(s => [s.time, s]));
    
                        for (const oldSlot of oldSlots) {
                            if (!newSlotMap.has(oldSlot.time)) {
                                oldSlot.available = "0";
                                oldSlot.used = oldSlot.capacity;
                                newSlots.push(oldSlot);
                            }
                        }
                        newDay.T = newSlots;
                    } else if (oldDay.T && !newDay.T) {
                        const oldSlots = Array.isArray(oldDay.T) ? oldDay.T : [oldDay.T];
                         oldSlots.forEach(slot => {
                            slot.available = "0";
                            slot.used = slot.capacity;
                        });
                        newDay.T = oldSlots;
                    }
                }
            }
            return newDays;
        };
    
        if (newData.express?.SERVICE?.DATES?.D) {
            newData.express.SERVICE.DATES.D = mergeKeywordCalendarData(oldData.express?.SERVICE?.DATES?.D, newData.express.SERVICE.DATES.D);
        }
        if (newData.tages?.SERVICE?.DATES?.D) {
            newData.tages.SERVICE.DATES.D = mergeKeywordCalendarData(oldData.tages?.SERVICE?.DATES?.D, newData.tages.SERVICE.DATES.D);
        }
         if (newData.halloween?.SERVICE?.DATES?.D) {
            newData.halloween.SERVICE.DATES.D = mergeKeywordCalendarData(oldData.halloween?.SERVICE?.DATES?.D, newData.halloween.SERVICE.DATES.D);
        }
    
        const packageTypes = ['peppaParty', 'drachenParty', 'ghostbustersParty', 'heideparkParty', 'fotoPass', 'parkplatz'];
        for (const type of packageTypes) {
            if (newData[type]?.SERVICE?.D) {
                 const oldD = oldData[type]?.SERVICE?.D;
                 const newD = newData[type]?.SERVICE?.D;
                 newData[type].SERVICE.D = mergePackageData(oldD, newD);
            }
        }
    
        const mazeTypes = ['subterraMaze', 'mortonMaze', 'parasomnisMaze'];
        for (const type of mazeTypes) {
            if (newData[type]?.SERVICE?.D) {
                 const oldD = oldData[type]?.SERVICE?.D;
                 const newD = newData[type]?.SERVICE?.D;
                 newData[type].SERVICE.D = mergeMazeData(oldD, newD);
            }
        }
    
        return newData;
    }

    function updateLastUpdatedTimer() {
        chrome.storage.local.get('cacheTimestamp', (result) => {
            if (result.cacheTimestamp) {
                const now = new Date().getTime();
                const lastUpdate = new Date(result.cacheTimestamp);
                const diffSeconds = Math.round((now - lastUpdate.getTime()) / 1000);

                let text = 'Aktualisiert: ';
                if (diffSeconds < 10) {
                    text += 'gerade eben';
                } else if (diffSeconds < 60) {
                    text += `vor ${diffSeconds} Sek.`;
                } else {
                    const diffMinutes = Math.floor(diffSeconds / 60);
                    text += `vor ${diffMinutes} Min.`;
                }
                lastUpdatedDisplay.textContent = text;
                lastUpdatedDisplay.title = `Zuletzt aktualisiert am ${lastUpdate.toLocaleDateString('de-DE')} um ${lastUpdate.toLocaleTimeString('de-DE')}`;
            } else {
                lastUpdatedDisplay.textContent = 'Noch nicht geladen';
            }
        });
    }

    function renderSummary(data) {
        const today = getLocalDate();
        const now = new Date();
        const prettyDate = now.toLocaleDateString('de-DE', { day: '2-digit', month: '2-digit', year: 'numeric' });
        
        let summaryHTML = `<div class="summary-item"><span class="summary-label">Heute</span><span class="summary-value">${prettyDate}</span></div>`;

        const todaysExpressData = data?.express?.SERVICE?.DATES?.D.find(d => d.date === today);
        if (todaysExpressData?.PS?.P) {
            const tickets = Array.isArray(todaysExpressData.PS.P) ? todaysExpressData.PS.P : [todaysExpressData.PS.P];
            const expressTypes = { 'Platin 🏆': 'platin', 'Gold 🥇': 'gold', 'Silber 🥈': 'silber', 'Bronze 🥉': 'bronze' };
            for (const [key, value] of Object.entries(expressTypes)) {
                const ticket = tickets.find(p => p.name?.trim().toLowerCase().includes(value));
                if (ticket) {
                    const capacity = parseInt(ticket.capacity, 10);
                    const sold = ticket.soldOut ? capacity : capacity - parseInt(ticket.available, 10);
                    const percentage = capacity > 0 ? (sold / capacity) * 100 : 0;
                    const colorClass = getSoldClass(sold, capacity);
                    
                    summaryHTML += `
                        <div class="summary-item">
                            <span class="summary-label">${key}</span>
                            <div class="summary-progress-bar-container">
                                <div class="summary-progress-bar ${colorClass}" style="width: ${percentage}%;"></div>
                                <div class="summary-progress-bar-text">${sold} / ${capacity}</div>
                            </div>
                        </div>`;
                }
            }
        }

        const todaysTagesData = data?.tages?.SERVICE?.DATES?.D.find(d => d.date === today);
        if (todaysTagesData?.PS?.P) {
            const tagesTicket = (Array.isArray(todaysTagesData.PS.P) ? todaysTagesData.PS.P : [todaysTagesData.PS.P]).find(p => p.name?.trim() === "1-Tages-Ticket");
            if (tagesTicket) {
                const capacity = parseInt(tagesTicket.capacity, 10);
                const sold = tagesTicket.soldOut ? capacity : capacity - parseInt(tagesTicket.available, 10);
                const percentage = capacity > 0 ? (sold / capacity) * 100 : 0;
                const colorClass = getSoldClass(sold, capacity);

                summaryHTML += `
                    <div class="summary-item">
                        <span class="summary-label">Tages-Ticket 🎫</span>
                        <div class="summary-progress-bar-container">
                            <div class="summary-progress-bar ${colorClass}" style="width: ${percentage}%;"></div>
                            <div class="summary-progress-bar-text">${sold} / ${capacity}</div>
                        </div>
                    </div>`;
            }
        }
        summaryBar.innerHTML = summaryHTML.includes('summary-value') || summaryHTML.includes('summary-progress') ? summaryHTML : "Keine Daten für heute verfügbar.";
    }

    function renderExpressTable(data) {
        const version = EXPRESS_TICKET_VERSIONS[currentExpressIndex];
        if (!data?.SERVICE?.DATES?.D) { div.innerHTML = "Keine Express-Ticketdaten gefunden!"; return; }
        const dateMap = {};
        const allDays = data.SERVICE.DATES.D;
        const allDates = [...new Set(allDays.map(day => day.date))].sort();

        const versionKeyword = version.split(' ')[2].toLowerCase();
        for (const day of allDays) {
            if (day.PS?.P) {
                const tickets = Array.isArray(day.PS.P) ? day.PS.P : [day.PS.P];
                const ticket = tickets.find(p => p.name?.trim().toLowerCase().includes(versionKeyword));
                if (ticket) {
                    dateMap[day.date] = { 
                        available: parseInt(ticket.available, 10) || 0, 
                        capacity: parseInt(ticket.capacity, 10) || 0,
                        soldOut: ticket.soldOut || false
                    };
                }
            }
        }
        
        const startDate = allDates[0];
        const endDate = allDates[allDates.length - 1];
        const today = getLocalDate();
        let html = `<table><thead><tr><th>Datum</th><th>Verkauft</th><th>Verfügbar</th><th>Kapazität</th><th class="name-col">Name</th></tr></thead><tbody>`;
        
        for (const d of dateRangeISO(startDate, endDate)) {
            const prettyDate = d.replace(/^(\d{4})-(\d{2})-(\d{2})$/, "$3.$2.$1");
            const isTodayClass = d === today ? 'class="today-row"' : '';
            if (dateMap[d]) {
                const sold = dateMap[d].soldOut ? dateMap[d].capacity : (dateMap[d].capacity - dateMap[d].available);
                let soldClass = getSoldClass(sold, dateMap[d].capacity);
                
                if (dateMap[d].soldOut || dateMap[d].available === 0) {
                    html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4"><span class="none-row">Ausverkauft (${sold}/${dateMap[d].capacity})</span></td></tr>`;
                } else {
                    html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td><span class="sold ${soldClass}">${sold}</span></td><td>${dateMap[d].available}</td><td>${dateMap[d].capacity}</td><td class="name-col">${version}</td></tr>`;
                }
            } else {
                html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4" class="none-row">Kein ${version} verfügbar</td></tr>`;
            }
        }
        html += "</tbody></table>";
        div.innerHTML = html;
    }

    function renderTagesView(data) {
        const version = TAGES_TICKET_VERSIONS[currentTagesIndex];
        if (version === "Tages- & Abend-Ticket") {
            renderTagesUndAbendTable(data);
        } else if (version === "Foto-Pass 📸") {
            renderFotoPassTable(data.fotoPass);
        } else if (version === "Parkplatz 🅿️") {
            renderParkplatzTable(data.parkplatz);
        }
    }
    
    function renderPartyView(data) {
        const version = PARTY_PAKETE_VERSIONS[currentPartyIndex];
        let partyData;
        switch (version) {
            case "Peppas Party-Paket 🐷": partyData = data.peppaParty; break;
            case "Drachenzähmen Party-Paket 🐉": partyData = data.drachenParty; break;
            case "Ghostbusters Party-Paket 👻": partyData = data.ghostbustersParty; break;
            case "Heide Park Party-Paket 🎉": partyData = data.heideparkParty; break;
        }
        renderPartyPaketTable(partyData, version);
    }

    function renderMazeView(data) {
        const version = MAZE_TICKET_VERSIONS[currentMazeIndex];
        let mazeData;
        switch(version) {
            case "SubTerra": mazeData = data.subterraMaze; break;
            case "Grand Hotel Morton": mazeData = data.mortonMaze; break;
            case "Parasomnis": mazeData = data.parasomnisMaze; break;
        }
        renderMazeTable(mazeData, version);
    }

    function renderTagesUndAbendTable(data) {
        const { tages, halloween } = data;
        if (!tages?.SERVICE?.DATES?.D && !halloween?.SERVICE?.DATES?.D) { div.innerHTML = "Keine Tages- oder Abend-Ticketdaten gefunden!"; return; }
        const dateMap = {};
        const allDates = new Set();
        if (tages?.SERVICE?.DATES?.D) {
            for (const day of tages.SERVICE.DATES.D) {
                allDates.add(day.date);
                if (!dateMap[day.date]) dateMap[day.date] = [];
                if (day.PS?.P?.length) for (const ticket of (Array.isArray(day.PS.P) ? day.PS.P : [day.PS.P])) {
                    if (ticket.name?.trim() === "1-Tages-Ticket") {
                        dateMap[day.date].push({ name: "Tages-Ticket", available: parseInt(ticket.available, 10) || 0, capacity: parseInt(ticket.capacity, 10) || 0 });
                    }
                }
            }
        }
        if (halloween?.SERVICE?.DATES?.D) {
            for (const day of halloween.SERVICE.DATES.D) {
                allDates.add(day.date);
                if (!dateMap[day.date]) dateMap[day.date] = [];
                if (day.PS?.P?.length) for (const ticket of (Array.isArray(day.PS.P) ? day.PS.P : [day.PS.P])) if (ticket.name?.includes("Abendticket Halloween")) dateMap[day.date].push({ name: "Abendtickets🎃", available: parseInt(ticket.available, 10) || 0, capacity: parseInt(ticket.capacity, 10) || 0 });
            }
        }
        const dateObjs = Array.from(allDates).map(d => new Date(d));
        if (dateObjs.length === 0) { div.innerHTML = "Keine Ticketdaten für den Zeitraum gefunden."; return; }
        const startDate = new Date(Math.min(...dateObjs)).toISOString().slice(0, 10);
        const endDate = new Date(Math.max(...dateObjs)).toISOString().slice(0, 10);
        const today = getLocalDate();
        let html = `<table><thead><tr><th>Datum</th><th>Verkauft</th><th>Verfügbar</th><th>Kapazität</th><th class="name-col">Name</th></tr></thead><tbody>`;
        for (const d of dateRangeISO(startDate, endDate)) {
            const prettyDate = d.replace(/^(\d{4})-(\d{2})-(\d{2})$/, "$3.$2.$1");
            if (dateMap[d] && dateMap[d].length > 0) {
                dateMap[d].forEach((ticket, index) => {
                    const isLast = index === dateMap[d].length - 1;
                    const sold = ticket.capacity - ticket.available;
                    let soldClass = getSoldClass(sold, ticket.capacity);
                    const isTodayClass = d === today ? 'today-row' : '';
                    const abendClass = ticket.name.includes("🎃") ? 'abend-ticket-row' : '';
                    html += `<tr class="${isTodayClass} ${abendClass} ${isLast ? 'day-separator' : ''}">
                        ${index === 0 ? `<td rowspan="${dateMap[d].length}">${prettyDate}</td>` : ''}
                        <td><span class="sold ${soldClass}">${sold}</span></td>
                        <td>${ticket.available}</td>
                        <td>${ticket.capacity}</td>
                        <td class="name-col">${ticket.name}</td>
                    </tr>`;
                });
            } else {
                const isTodayClass = d === today ? 'class="today-row"' : '';
                html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4" class="none-row">Keine Tickets verfügbar</td></tr>`;
            }
        }
        html += "</tbody></table>";
        div.innerHTML = html;
    }

    function renderFotoPassTable(data) {
        const fotoPassData = data?.SERVICE?.D;
        if (!fotoPassData || !Array.isArray(fotoPassData)) { 
            div.innerHTML = "Keine Foto-Pass-Daten gefunden!"; 
            return; 
        }
        const dateMap = {};
        const dateStrings = fotoPassData.map(day => day.date);
        for (const day of fotoPassData) {
            const availability = day.T;
            if (availability) {
                dateMap[day.date] = { 
                    sold: parseInt(availability.used, 10) || 0,
                    available: parseInt(availability.available, 10) || 0, 
                    capacity: parseInt(availability.capacity, 10) || 0 
                };
            }
        }
        const dateObjs = dateStrings.map(d => new Date(d));
        if (dateObjs.length === 0) { div.innerHTML = "Keine Foto-Pass-Daten für den Zeitraum gefunden."; return; }
        const startDate = new Date(Math.min(...dateObjs)).toISOString().slice(0, 10);
        const endDate = new Date(Math.max(...dateObjs)).toISOString().slice(0, 10);
        const today = getLocalDate();
        let html = `<table><thead><tr><th>Datum</th><th>Verkauft</th><th>Verfügbar</th><th>Kapazität</th><th class="name-col">Name</th></tr></thead><tbody>`;
        for (const d of dateRangeISO(startDate, endDate)) {
            const prettyDate = d.replace(/^(\d{4})-(\d{2})-(\d{2})$/, "$3.$2.$1");
            const isTodayClass = d === today ? 'class="today-row"' : '';
            if (dateMap[d]) {
                const sold = dateMap[d].sold;
                let soldClass = getSoldClass(sold, dateMap[d].capacity);
                if (dateMap[d].available === 0) {
                     html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4"><span class="none-row">Ausverkauft (${sold}/${dateMap[d].capacity})</span></td></tr>`;
                } else {
                    html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td><span class="sold ${soldClass}">${sold}</span></td><td>${dateMap[d].available}</td><td>${dateMap[d].capacity}</td><td class="name-col">Foto-Pass 📸</td></tr>`;
                }
            } else {
                html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4" class="none-row">Kein Foto-Pass verfügbar</td></tr>`;
            }
        }
        html += "</tbody></table>";
        div.innerHTML = html;
    }

    function renderParkplatzTable(data) {
        const parkplatzData = data?.SERVICE?.D;
        if (!parkplatzData || !Array.isArray(parkplatzData)) { 
            div.innerHTML = "Keine Parkplatz-Daten gefunden!"; 
            return; 
        }
        const dateMap = {};
        const dateStrings = parkplatzData.map(day => day.date);
        for (const day of parkplatzData) {
            const availability = day.T;
            if(availability) {
                dateMap[day.date] = { 
                    sold: parseInt(availability.used, 10) || 0, 
                    available: parseInt(availability.available, 10) || 0, 
                    capacity: parseInt(availability.capacity, 10) || 0 
                };
            }
        }
        const dateObjs = dateStrings.map(d => new Date(d));
        if (dateObjs.length === 0) { div.innerHTML = "Keine Parkplatz-Daten für den Zeitraum gefunden."; return; }
        const startDate = new Date(Math.min(...dateObjs)).toISOString().slice(0, 10);
        const endDate = new Date(Math.max(...dateObjs)).toISOString().slice(0, 10);
        const today = getLocalDate();
        let html = `<table><thead><tr><th>Datum</th><th>Verkauft</th><th>Verfügbar</th><th>Kapazität</th><th class="name-col">Name</th></tr></thead><tbody>`;
        for (const d of dateRangeISO(startDate, endDate)) {
            const prettyDate = d.replace(/^(\d{4})-(\d{2})-(\d{2})$/, "$3.$2.$1");
            const isTodayClass = d === today ? 'class="today-row"' : '';
            if (dateMap[d]) {
                const sold = dateMap[d].sold;
                let soldClass = getSoldClass(sold, dateMap[d].capacity);
                 if (dateMap[d].available === 0) {
                     html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4"><span class="none-row">Ausverkauft (${sold}/${dateMap[d].capacity})</span></td></tr>`;
                } else {
                    html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td><span class="sold ${soldClass}">${sold}</span></td><td>${dateMap[d].available}</td><td>${dateMap[d].capacity}</td><td class="name-col">Parkplatz 🅿️</td></tr>`;
                }
            } else {
                html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4" class="none-row">Kein Parkplatz-Ticket verfügbar</td></tr>`;
            }
        }
        html += "</tbody></table>";
        div.innerHTML = html;
    }

    function renderPartyPaketTable(data, name) {
        let partyDays = data?.SERVICE?.D;
        if (!partyDays) {
            div.innerHTML = `Keine Daten für "${name}" gefunden!`;
            return;
        }
        if (!Array.isArray(partyDays)) {
            partyDays = [partyDays];
        }

        const dateMap = {};
        const dateStrings = partyDays.map(day => day.date);

        for (const day of partyDays) {
            const availability = day.T;
            if (availability) {
                dateMap[day.date] = { 
                    sold: parseInt(availability.used, 10) || 0,
                    available: parseInt(availability.available, 10) || 0, 
                    capacity: parseInt(availability.capacity, 10) || 0 
                };
            }
        }
        
        const dateObjs = dateStrings.map(d => new Date(d));
        if (dateObjs.length === 0) { div.innerHTML = "Keine Daten für den Zeitraum gefunden."; return; }
        const startDate = new Date(Math.min(...dateObjs)).toISOString().slice(0, 10);
        const endDate = new Date(Math.max(...dateObjs)).toISOString().slice(0, 10);
        const today = getLocalDate();

        let html = `<table><thead><tr><th>Datum</th><th>Verkauft</th><th>Verfügbar</th><th>Kapazität</th><th class="name-col">Name</th></tr></thead><tbody>`;
        for (const d of dateRangeISO(startDate, endDate)) {
            const prettyDate = d.replace(/^(\d{4})-(\d{2})-(\d{2})$/, "$3.$2.$1");
            const isTodayClass = d === today ? 'class="today-row"' : '';
            if (dateMap[d] && dateMap[d].capacity > 0) {
                const sold = dateMap[d].sold;
                let soldClass = getSoldClass(sold, dateMap[d].capacity);
                 if (dateMap[d].available === 0) {
                     html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4"><span class="none-row">Ausverkauft (${sold}/${dateMap[d].capacity})</span></td></tr>`;
                } else {
                    html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td><span class="sold ${soldClass}">${sold}</span></td><td>${dateMap[d].available}</td><td>${dateMap[d].capacity}</td><td class="name-col">${name}</td></tr>`;
                }
            } else {
                html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4" class="none-row">Kein Paket verfügbar</td></tr>`;
            }
        }
        html += "</tbody></table>";
        div.innerHTML = html;
    }
    
    function renderMazeTable(data, name) {
        let mazeDays = data?.SERVICE?.D;
        if (!mazeDays) {
            div.innerHTML = `Keine Daten für "${name}" gefunden!`;
            return;
        }
        if (!Array.isArray(mazeDays)) {
            mazeDays = [mazeDays];
        }

        const dateMap = {};
        let allDates = new Set();

        for (const day of mazeDays) {
            if (!dateMap[day.date]) {
                dateMap[day.date] = [];
            }
            allDates.add(day.date);

            const timeSlots = Array.isArray(day.T) ? day.T : (day.T ? [day.T] : []);
            
            for (const availability of timeSlots) {
                if (availability) {
                    dateMap[day.date].push({
                        time: formatTime(availability.time),
                        sold: parseInt(availability.used, 10) || 0,
                        available: parseInt(availability.available, 10) || 0,
                        capacity: parseInt(availability.capacity, 10) || 0
                    });
                }
            }
        }
        
        const dateObjs = Array.from(allDates).map(d => new Date(d));
        if (dateObjs.length === 0) { div.innerHTML = "Keine Daten für den Zeitraum gefunden."; return; }
        
        const sortedDates = Array.from(allDates).sort();
        const startDate = sortedDates[0];
        const endDate = sortedDates[sortedDates.length - 1];
        const today = getLocalDate();

        let html = `<table><thead><tr><th>Datum</th><th>Zeit</th><th>Verkauft</th><th>Verfügbar</th><th>Kapazität</th></tr></thead><tbody>`;
        for (const d of dateRangeISO(startDate, endDate)) {
            const prettyDate = d.replace(/^(\d{4})-(\d{2})-(\d{2})$/, "$3.$2.$1");
            const isTodayClass = d === today ? 'class="today-row"' : '';

            if (dateMap[d] && dateMap[d].length > 0) {
                dateMap[d].sort((a, b) => a.time.localeCompare(b.time));
                dateMap[d].forEach((slot, index) => {
                    if(slot.capacity > 0) {
                        const isLastSlotOfDay = index === dateMap[d].length - 1;
                        const separatorClass = isLastSlotOfDay ? 'day-separator' : '';
                        let soldClass = getSoldClass(slot.sold, slot.capacity);

                        if (slot.available === 0) {
                            html += `<tr class="${isTodayClass} ${separatorClass}">
                                ${index === 0 ? `<td rowspan="${dateMap[d].length}">${prettyDate}</td>` : ''}
                                <td>${slot.time}</td>
                                <td colspan="3"><span class="none-row">Ausverkauft (${slot.sold}/${slot.capacity})</span></td>
                            </tr>`;
                        } else {
                            html += `<tr class="${isTodayClass} ${separatorClass}">
                                ${index === 0 ? `<td rowspan="${dateMap[d].length}">${prettyDate}</td>` : ''}
                                <td>${slot.time}</td>
                                <td><span class="sold ${soldClass}">${slot.sold}</span></td>
                                <td>${slot.available}</td>
                                <td>${slot.capacity}</td>
                            </tr>`;
                        }
                    }
                });
            } else {
                html += `<tr class="${isTodayClass} day-separator"><td>${prettyDate}</td><td colspan="4" class="none-row">Für diesen Tag keine Timeslots verfügbar</td></tr>`;
            }
        }
        html += "</tbody></table>";
        div.innerHTML = html;
    }

    function formatTime(timeStr) {
        if (!timeStr) return "";
        let [time, modifier] = timeStr.split(' ');
        let [hours, minutes] = time.split(':');
        
        hours = parseInt(hours, 10);
        
        if (modifier === 'PM' && hours < 12) {
            hours += 12;
        }
        if (modifier === 'AM' && hours === 12) {
            hours = 0;
        }
        
        return `${hours.toString().padStart(2, '0')}:${minutes}`;
    }
});