// ###################################################################################
// ### NUR FÜR DIE "TOOLS"-SEKTION ZUSTÄNDIG                                       ###
// ###################################################################################

document.addEventListener("DOMContentLoaded", () => {
    const PROMO_API_URL = 'https://me-hpgermany.tickets.heide-park.de/api/request/getgiftcoderemainingcount';
    const PROMO_REFERER_URL = 'https://me-hpgermany.tickets.heide-park.de/giftcode/65489';
    const PROMO_BASE_PAYLOAD = { "gift_offer_id":"18325", "request_type":"GetGiftCodeRemainingCount", "_version":"6.17.9", "application_id":"1500", "merchant_id":"6500", "machine_id":"500", "agent_id":"5", "user_id":"5", "device":"desktop", "language":"de-de", "request_token":"33465727AB9229373D05D4138367D4DC", "cart_id":"536506217", "cart_key":"4205873474", "session_id":"ftsq.193253.484" };
    
    const promoCodeInput = document.getElementById('promo-code-input');
    const checkPromoCodeBtn = document.getElementById('check-promo-code-btn');
    const promoCodeResult = document.getElementById('promo-code-result');

    async function checkPromoCode() {
        const code = promoCodeInput.value.trim();
        if (!code) {
            promoCodeResult.textContent = 'Bitte einen Code eingeben.';
            promoCodeResult.style.color = 'orange';
            return;
        }
        promoCodeResult.textContent = 'Prüfe...';
        promoCodeResult.style.color = '';
        checkPromoCodeBtn.disabled = true;

        const payload = { ...PROMO_BASE_PAYLOAD, gift_code: code };

        try {
            const response = await executeBackgroundFetch(PROMO_API_URL, payload, PROMO_REFERER_URL);
            
            if (response && response.SERVICE && response.SERVICE.remaining_count) {
                const count = parseInt(response.SERVICE.remaining_count, 10);

                // *** HIER IST DIE KORREKTUR ***
                if (count === -1) {
                    promoCodeResult.textContent = "Ungültiger Code.";
                    promoCodeResult.style.color = 'red';
                } else {
                    promoCodeResult.textContent = `Noch verfügbar: ${count}`;
                    promoCodeResult.style.color = count > 0 ? 'green' : 'red';
                }

            } else if (response && response.SERVICE && response.SERVICE.error_message) {
                promoCodeResult.textContent = `Fehler: ${response.SERVICE.error_message}`;
                promoCodeResult.style.color = 'red';
            } else {
                throw new Error('Ungültige Antwort von der API.');
            }
        } catch (error) {
            promoCodeResult.textContent = `Fehler: ${error.message}`;
            promoCodeResult.style.color = 'red';
        } finally {
            checkPromoCodeBtn.disabled = false;
        }
    }
    
    function executeBackgroundFetch(apiUrl, apiPayload, refererUrl) {
        return new Promise((resolve, reject) => {
            const funcToExecute = (url, payload, headers) => fetch(url, { method: "POST", headers, body: JSON.stringify(payload), credentials: "include" }).then(r => { if (!r.ok) throw new Error(`HTTP-Fehler ${r.status}`); return r.json(); }).catch(e => ({ error: e.message }));
            const apiHeaders = { 'Accept': 'application/json, text/plain, */*', 'Content-Type': 'application/json;charset=UTF-8', 'com-accessopassport-app-id': '1500', 'com-accessopassport-client': 'accesso26', 'com-accessopassport-language': 'de-de', 'com-accessopassport-merchant-id': '6500' };
            const scriptToExecute = (tabId) => {
                chrome.scripting.executeScript({ target: { tabId }, func: funcToExecute, args: [apiUrl, apiPayload, apiHeaders] }, (results) => {
                    chrome.tabs.remove(tabId);
                    if (chrome.runtime.lastError) return reject(new Error(chrome.runtime.lastError.message));
                    const data = results?.[0]?.result;
                    if (data && !data.error) resolve(data);
                    else reject(new Error(data?.error || "Skript-Ausführung fehlgeschlagen."));
                });
            };
            const waitForTab = (tabId) => {
                const listener = (updatedTabId, changeInfo) => {
                    if (updatedTabId === tabId && changeInfo.status === 'complete') {
                        chrome.tabs.onUpdated.removeListener(listener);
                        scriptToExecute(tabId);
                    }
                };
                chrome.tabs.onUpdated.addListener(listener);
            };
            chrome.tabs.create({ url: refererUrl, active: false }, (newTab) => {
                if (newTab && newTab.id) {
                    waitForTab(newTab.id);
                } else {
                    reject(new Error('Konnte Hintergrund-Tab nicht erstellen.'));
                }
            });
        });
    }

    checkPromoCodeBtn.addEventListener('click', checkPromoCode);
    promoCodeInput.addEventListener('keyup', (e) => { if (e.key === 'Enter') checkPromoCode(); });
});